/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBData_Comum;
import fme.CBTabela;
import fme.CBTabela_Invs2;
import fme.CFLib;
import fme.CHTabColModel;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CTabelas;
import fme.Frame_DadosAccoes;
import fme.GroupableTableHeaderUI;
import fme.TabError;
import fme.TableKeyListener;
import fme._lib;

class CBTabela_Invs
extends CBTabela {
    Frame_DadosAccoes P;
    int tab_index = 0;
    int n_min = 8;
    int n_max = 20;
    int n_linhas = this.n_min;

    @Override
    public String getPagina() {
        return CBData.getPagina(null, "Accoes", CBData.ListaAccoes, this.tab_index);
    }

    CBTabela_Invs(Frame_DadosAccoes p, int idx) {
        this.P = p;
        this.tab_index = idx;
        this.initialize();
    }

    void initialize() {
        this.tag = "Inv";
        this.started = true;
        this.P.cbd_invs = this;
        this.cols = new CHTabColModel[8];
        this.cols[0] = new CHTabColModel("n_ordem", "N\u00ba", true, false, true, CFLib.VLD_INT);
        this.cols[1] = new CHTabColModel("rubrica", "Rubrica (id)", true, true, false, null);
        this.cols[2] = new CHTabColModel("rubrica_d", "Rubrica", true, true, true, null);
        this.cols[3] = new CHTabColModel("rubrica_txt", "Rubrica Descri\u00e7\u00e3o", true, true, true, null);
        this.cols[4] = new CHTabColModel("valor_f1", "Custo do Investimento - Fase 1", true, CBData.Params.fases > 0, true, CFLib.VLD_FORMULA);
        this.cols[5] = new CHTabColModel("valor_f2", "Custo do Investimento - Fase 2", true, CBData.Params.fases > 1, true, CFLib.VLD_FORMULA);
        this.cols[6] = new CHTabColModel("valor_f3", "Custo do Investimento - Fase 3", true, CBData.Params.fases > 2, true, CFLib.VLD_FORMULA);
        this.cols[7] = new CHTabColModel("valor_tt", "Custo do Investimento - Total", true, false, true, CFLib.VLD_VALOR_0);
        this.init_dados(this.n_min);
        this.init_handler(this.P.getJTable_Invs());
        this.P.getJTable_Invs().addKeyListener(new TableKeyListener(this));
        this.handler.width = this.P.getJScrollPane_Invs().getWidth() - 2;
        this.ui = new GroupableTableHeaderUI();
        this.ui.setH(2, this.P.getJTable_Invs());
        this.ui.add_col(0, 0, 1, 2, "N\u00ba");
        this.ui.add_col(1, 0, 2, 2, "Descri\u00e7\u00e3o das Despesas");
        this.ui.add_col(3, 0, 4, 1, "Custo do Investimento");
        this.ui.add_col(3, 1, 1, 1, "Fase 1");
        this.ui.add_col(4, 1, 1, 1, "Fase 2");
        this.ui.add_col(5, 1, 1, 1, "Fase 3");
        this.ui.add_col(6, 1, 1, 1, "Total");
        this.P.getJTable_Invs().getTableHeader().setUI(this.ui);
        this.handler.set_col_text(0, 0.045, "C");
        this.handler.set_col_comboS(2, 0.259, null, CTabelas.Rubricas, 1, 240);
        this.handler.set_col_text(3, 0.2, "L");
        this.handler.set_col_text(4, 0.12, "R");
        this.handler.set_col_text(5, 0.12, "R");
        this.handler.set_col_text(6, 0.12, "R");
        this.handler.set_col_text(7, 0.12, "R");
    }

    @Override
    void on_update(String colname, int nRow, String v) {
        this.numerar(0);
        if (colname.equals("rubrica_d")) {
            String rubrica = "";
            if (v.length() > 0) {
                rubrica = CTabelas.Rubricas.lookup(1, v, 0);
            }
            this.setColValue("rubrica", nRow, rubrica);
        }
        if (colname.equals("rubrica")) {
            String rubrica_d = "";
            if (v.length() > 0) {
                rubrica_d = CTabelas.Rubricas.lookup(0, v, 1);
            }
            this.setColValue("rubrica_d", nRow, rubrica_d);
        }
        if (colname.startsWith("valor_")) {
            this.upd_col_sum(colname);
            String f1 = this.getColValue("valor_f1", nRow);
            String f2 = this.getColValue("valor_f2", nRow);
            String f3 = this.getColValue("valor_f3", nRow);
            if ((String.valueOf(f1) + f2 + f3).equals("")) {
                this.setColValue("valor_tt", nRow, "");
            } else {
                double total = this.getColValueAsDouble("valor_f1", nRow) + this.getColValueAsDouble("valor_f2", nRow) + this.getColValueAsDouble("valor_f3", nRow);
                this.setColValue("valor_tt", nRow, total == 0.0 ? "0" : String.valueOf(_lib.round(total)));
            }
        }
    }

    void upd_col_sum(String colname) {
        double sum = this.getSum_v25b(colname);
        this.P.cbd_invs2.setColValue(colname, 0, String.valueOf(sum));
        this.P.cbd_invs2.on_update(colname, 0, String.valueOf(sum));
    }

    void upd_cols_sum() {
        this.upd_col_sum("valor_f1");
        this.upd_col_sum("valor_f2");
        this.upd_col_sum("valor_f3");
    }

    @Override
    public void add_row() {
        if (this.dados.size() < this.n_max) {
            this.P.add_del_linha(-1);
        }
        super.add_row();
    }

    @Override
    void numerar(int nCol) {
        int n = 1;
        int i = 0;
        while (i < this.dados.size()) {
            ((String[])this.dados.elementAt((int)i))[nCol] = !this.isRowEmpty(i) ? Integer.toString(n++) : "";
            ++i;
        }
    }

    CHValid_Grp validar(CHValid_Grp err_list, String cp) {
        String titulo = "Investimentos";
        if (cp.length() > 0) {
            titulo = String.valueOf(titulo) + cp;
        }
        if (err_list == null) {
            err_list = new CHValid_Grp(this, titulo);
        }
        if (this.isEmpty()) {
            err_list.add_msg(new CHValid_Msg("Lista vazia"));
        } else {
            StringBuffer mask = new StringBuffer("--RR???-");
            mask.setCharAt(4, CBData.Params.fases > 0 ? (char)'R' : '-');
            mask.setCharAt(5, CBData.Params.fases > 1 ? (char)'R' : '-');
            mask.setCharAt(6, CBData.Params.fases > 2 ? (char)'R' : '-');
            int j = 0;
            while (j < this.dados.size()) {
                if (!this.isRowEmpty(j)) {
                    TabError[] e = this.isIncompletAll(j, mask.toString());
                    int ii = 0;
                    while (e != null && ii < e.length) {
                        err_list.add_msg(new CHValid_Msg(e[ii]));
                        String rubrica_txt = this.getColValue("rubrica_txt", ii);
                        if (rubrica_txt.length() > 0 && rubrica_txt.length() > 120) {
                            err_list.add_msg(new CHValid_Msg(e[ii], e[ii].msg("Linha %L texto demasiado longo. Reduza para 120 caracteres.")));
                        }
                        ++ii;
                    }
                }
                ++j;
            }
            CBTabela_Invs2 invs2 = (CBTabela_Invs2)CBData.ListaAccoes.Lista_Invs2.elementAt(this.tab_index - 1);
            invs2.validar(err_list, cp);
            int i = 0;
            while (i < invs2.cols.length) {
                if (invs2.cols[i].col_tag.startsWith("valor_f")) {
                    if (_lib.round(_lib.to_double(invs2.getColValue(invs2.cols[i].col_tag, 1))) > _lib.round(_lib.to_double(invs2.getColValue(invs2.cols[i].col_tag, 0)) * 0.13)) {
                        err_list.add_msg(new CHValid_Msg((CBData_Comum)invs2, String.valueOf(invs2.cols[i].col_name2) + " - '" + invs2.getColValue("rubrica_d", 1) + "' n\u00e3o pode ser superior a 13% de '" + invs2.getColValue("rubrica_d", 0) + "'", 1, i));
                    }
                    if (_lib.round(_lib.to_double(invs2.getColValue(invs2.cols[i].col_tag, 2))) < _lib.round(_lib.to_double(invs2.getColValue(invs2.cols[i].col_tag, 3)))) {
                        err_list.add_msg(new CHValid_Msg((CBData_Comum)invs2, String.valueOf(invs2.cols[i].col_name2) + " - '" + invs2.getColValue("rubrica_d", 2) + "' n\u00e3o pode ser inferior a '" + invs2.getColValue("rubrica_d", 3) + "'", 3, i));
                    }
                }
                ++i;
            }
        }
        return err_list;
    }
}

